<?php
class AL_Widget extends WP_Widget {
	public function __construct() {
		parent::__construct( 'al_widget', 'アニメの名言集', array( 'description' => 'ランダムに名言を表示' ) );
	}

	public function form( $instance ) {
?>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">タイトル:</label><br />
<?php
$value_title = (isset($instance[ 'title' ])) ? $instance[ 'title' ] : '';
$value_class = (isset($instance[ 'class' ])) ? $instance[ 'class' ] : '';
$value_cache_time = (isset($instance[ 'cache_time' ])) ? $instance[ 'cache_time' ] : '300';
$value_margin_top = (isset($instance[ 'margin_top' ])) ? $instance[ 'margin_top' ] : '0';
$value_margin_bottom = (isset($instance[ 'margin_bottom' ])) ? $instance[ 'margin_bottom' ] : '28';

?>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $value_title; ?>">
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'class' ); ?>">タイトルclass:</label><br />
			<input class="widefat" id="<?php echo $this->get_field_id( 'class' ); ?>" name="<?php echo $this->get_field_name( 'class' ); ?>" type="text" value="<?php echo $value_class; ?>">
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'class' ); ?>">キャッシュ時間(s):</label><br />
			<select id="<?php echo $this->get_field_id( 'cache_time' ); ?>" name="<?php echo $this->get_field_name( 'cache_time' ); ?>">
				<option value="0" <?php if ( $value_cache_time == 0 ) { echo 'selected'; } ?>>キャッシュなし</option>
				<option value="300" <?php if ( $value_cache_time == 300 ) { echo 'selected'; } ?>>5分</option>
				<option value="600" <?php if ( $value_cache_time == 600 ) { echo 'selected'; } ?>>10分</option>
				<option value="1800" <?php if ( $value_cache_time == 1800 ) { echo 'selected'; } ?>>30分</option>
				<option value="3600" <?php if ( $value_cache_time == 3600 ) { echo 'selected'; } ?>>60分</option>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'margin_top' ); ?>">余白上部:</label><br />
			<input class="widefat" id="<?php echo $this->get_field_id( 'margin_top' ); ?>" name="<?php echo $this->get_field_name( 'margin_top' ); ?>" type="text" value="<?php echo $value_margin_top; ?>">
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'margin_bottom' ); ?>">余白下部:</label><br />
			<input class="widefat" id="<?php echo $this->get_field_id( 'margin_bottom' ); ?>" name="<?php echo $this->get_field_name( 'margin_bottom' ); ?>" type="text" value="<?php echo $value_margin_bottom; ?>">
		</p>
<?php
	}

	public function update( $new, $old ) {
		$instance = wp_parse_args( $new, $old );
		return $instance;
	}

	public function widget( $args, $instance ) {
		extract( $args );

		if ( $instance['title'] != '' ) {
			if ( $instance['class'] != '' ) {
				echo '<h3 class="'.$instance['class'].'">' . $instance['title'] . '</h3>';
			} else {
				echo '<h3>' . $instance['title'] . '</h3>';
			}
		}
		if ( !isset($instance['cache_time']) ) $instance['cache_time'] = 300;
		if ( $instance['cache_time'] == '' ) $instance['cache_time'] = 300;

		if ( !isset($instance['margin_top']) ) $instance['margin_top'] = 0;
		if ( $instance['margin_top'] == '' ) $instance['margin_top'] = 0;

		if ( !isset($instance['margin_bottom']) ) $instance['margin_bottom'] = 28;
		if ( $instance['margin_bottom'] == '' ) $instance['margin_bottom'] = 28;

		$anime_lines = '';
		$cache_anime_lines = $this->get_db_cache('cache_anime_lines', $instance['cache_time']);
		if ( $cache_anime_lines === false ) {
			$data = @file_get_contents('https://anime-lines.com/request/get.php?t='.time());
			$pattern = '/\<\!--\[SIDE_START\]--\>([\s\S]*)\<\!--\[SIDE_END\]--\>/';
			preg_match_all( $pattern, $data, $match );
			if ( isset($match[0][0])) {;
				$anime_lines = $match[0][0];
				$this->set_db_cache('cache_anime_lines', $anime_lines);
			}
		} else {
			$anime_lines = $cache_anime_lines;
		}

$style = <<<EOD
<style>
#anime_lines_area {
	margin-top:{$instance['margin_top']}px;
	margin-bottom:{$instance['margin_bottom']}px;
}
</style>
EOD;

		echo $anime_lines.$style;

		wp_reset_postdata();
	}

    // キャッシュ取得処理
    function get_db_cache( $cache_key, $interval ) {

        $cache_key = md5($cache_key);

         // キャッシュ 保存時間を取得
        $save_time = get_option( $cache_key.'-save-time' );

        if (empty($save_time)) return false;

        if ( ( time() - $save_time ) < $interval ) {
            $cache = get_option( $cache_key.'-cache' );

            if ( $cache == '' ) {
                return false;
            } else {
                return $cache;
            }
        } else {
            return false;
        }
    }

    // キャッシュ保存
    function set_db_cache( $cache_key, $data ) {
        $cache_key = md5($cache_key);

        update_option( $cache_key.'-cache',      $data );  // データを登録
        update_option( $cache_key.'-save-time',  time() ); // 保存時間を登録
    }

}